// Texture.h

#ifndef __texture_h__
#define __texture_h__


#include <windows.h>
#include <GL/glu.h>

class Texture
{

public:
	Texture();
	void	load(char* filename);
	void	setParameter(GLenum pname, int param);
	void	makeCurrent();
	void	makeNotCurrent();
	int		getWidth() { return width; }
	int		getHeight() { return height; }
	bool	getError() { return error; }
	char*	getErrorMessage() { return textureErrorMessage; };



private:
	void loadFromBMP(char* filename);

	int			width;
	int			height;
	GLubyte*	textureBytes;
	bool		error;
	char*		textureErrorMessage;
	GLuint		textureName;
	GLint		ParmWrapS, ParmWrapT, ParmMagFilter, ParmMinFilter;

};

#endif   /* ifndef __texture_h__ */
