// PongInstructionScene.cpp

#include "PongInstructionsScene.h"

PongInstructionsScene::PongInstructionsScene(Pong* game) :
theGame(game)
{
}

PongInstructionsScene::~PongInstructionsScene()
{
	delete instructions;
}


bool PongInstructionsScene::setup()
{
	instructions = new GE161::GameObject(20, 20);
	GE161::Sprite* instructionsImage = new GE161::Sprite(450, 300);
	frameIndex = instructionsImage->makeFrame(GE161::Game::basePath() + "Instructions.png", 0, 0);
	instructions->attachSprite(instructionsImage);
	
	playGameRequested = false;
	exitRequested = false;

	GE161::Game::registerAsListener(GE161::Event::KEY_DOWN, this);

	instructionsText = new GE161::Texty(
		GE161::Game::basePath() + "sample.ttf", 16, true);
	
	GE161::Game::debugOut("PongInstructionsScene::setup completed!");
	return true;
}

int PongInstructionsScene::draw()
{
	instructions->draw(frameIndex);

	instructionsText->write("Avoid missing ball for high score.", 80, 100);
	instructionsText->write("Press space to start", 150, 150);
	instructionsText->write("Press X to quit.", 160, 170);

	if (playGameRequested)
	{
		return 1;		// don't call draw again, go on to next scene
	}
	else if (exitRequested)
	{
		return -1;		// stop program
	}

	return GE161::Game::CONTINUE_SCENE;
}

void PongInstructionsScene::onEvent(GE161::Event& event)
{
	if (event.type == GE161::Event::KEY_DOWN)  // this test isn't necessary
	{
		if (event.key == " ")
			playGameRequested = true;
		else if (event.key == "X")
			exitRequested = true;
	}
}
